dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 240, 250, "assets/images/table/cruise_6", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 2, 3, 180, 410, "assets/images/table/cruise", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 2, 400, 410, "assets/images/table/cruise_2", "assets/images/food/item_mark1", "R" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 1;
numServers = 1;

maxCoupleHappiness = 200;

-- Group 1


guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male04;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 5, 3000);


-- Group 2


guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = NOT_TABLE + table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 8, 30000);

-- Group 3

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 10, 60000);

-- Group 4

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + male02;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table1;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 12, 70000);


-- Group 4

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 15, 90000);

-- Group 5

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female01;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.percentRequestTissue = 30;
guest.matchType = female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 19, 120000);


LManager:AdjustGuestTolerance(150);

LManager:SetLevelSetting ("dogDelay", 75000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("speakerDelay", 120000); 
LManager:SetLevelSetting ("speakerChance", 40);



-- Set up the Level Settings
LManager:SetLevelNumber(3,7);
LManager:SetLevelScores(8000, 10500);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/uptempo_2.ogg","assets/audio/music/new_dance_1.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );